<?php

defined('PF_VERSION') OR exit('Access denied');

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
class Pf_Contactform_Shortcode extends Pf_Plugin_Shortcode_Controller
{

    private $private_key;
    private $url;

    public function __construct($attrs = array())
    {
        parent::__construct();
        $this->view->set_path('/plugins/contactform/public/views');
        $this->model = new Pf_Contact_Form_Model();
        $this->attrs = $attrs;
        $this->validator = Pf::validator();
        $this->mail = new Pf_Plugin_Mail();
        $this->url = $this->input->get('pf_page_url');
        $this->private_key = Pf::setting()->get_element_value('general', 'recaptcha_private_key');
    }

    public function contactform_main()
    {
        $id = isset($this->attrs['id']) ? $this->attrs['id'] : '';
        $data = get_option('contactform');
        if (empty($data) || empty($data[$id]['form']) || $data[$id]['status'] == 0) {
            return '';
        }
        $contact = $data[$id];
        if ($this->input->has_post('token') && Pf_Plugin_CSRF::is_valid($this->input->post('token'), $id)) {
            global $contactform_validator_error;
            $rules = $contact['validator'];
            $input_all = $this->replace_data($rules);
            $this->replace_data($rules, $input_all);
            if (isset($rules['captcha'])) {
                $recaptcha = recaptcha_check_answer($this->private_key, $_SERVER["REMOTE_ADDR"], $this->input->post("recaptcha_challenge_field"), $this->input->post("recaptcha_response_field"));
                $contactform_validator_error['captcha'] = !$recaptcha->is_valid ? array(__('Captcha is not correct', 'pf_contactform')) : array();
                unset($rules['captcha']);
            }
            $this->validator->validation_rules($rules);
            $this->validator->run($input_all);
            $contactform_validator_error = !empty($contactform_validator_error) ? array_merge($contactform_validator_error, $this->validator->get_readable_errors(false)) : $this->validator->get_readable_errors(false);
            try {
                if (empty($contactform_validator_error)) {
                    $html = sc_build_message($contact['mail']['message']);
                    $mail_config = $contact['mail']['config'];
                    $this->mail->send($mail_config, $html);
                    $notify = !empty($contact['mail']['notify']) ? $contact['mail']['notify'] : '<p>' . __('Your message has been sent successfully', 'contactform') . '</p>';
                    return $this->view->render('notify', array('notify' => $notify));
                }
            } catch (Exception $e) {
                return "<p>{$e->getMessage()}</p>";
            }
        }
        $class_attr = empty($contact['form_class']) ? '' : $contact['form_class'];
        $id_attr = empty($contact['form_id']) ? '' : $contact['form_id'];
        $html = "<form class='" . e($class_attr) . "' method='post' role='form' ";
        $html .= (!empty($contact['form_id']) ? "id='" . e($id_attr) . "'" : '') . ">";
        $html .= get_token_input(600, $id);
        $html .= Pf::shortcode()->exec($contact['form']);
        $html .='</form>';
        $this->data['form'] = $html;
        $this->data['title'] = $contact['title'];
        return $this->view->render('main', $this->data);
    }

    private function replace_data($rules)
    {
        $data = $this->input->post();
        foreach ($rules as $key => $value) {
            $tmp = explode('|', $value);
            if (in_array('date', $tmp) && isset($data[$key])) {
                $data[$key] = convert_date($data[$key], 'Y-m-d');
            }
        }
        return $data;
    }

}
